import re, os
from MyScripts.helper import *
from MyScripts.analitic_geometry import *
import MyScripts.references as ref
from datetime import datetime

@arg_file_handler
def termination(file_path, prt=False):
    occ_count = 0
    with open(file_path) as handle:
        for line in handle:
            if line.strip().startswith('Normal termination'):
                occ_count += 1
    if prt:
        if occ_count:
            print(f'<{file_path}> had {occ_count} normal terminations')
        else:
            print(f'<{file_path}> did not terminate normally')
    return occ_count

@arg_file_handler
def molecular(file_path, select, conv=False, const=627.503):
    out = None
    if ref.mol_tags[select][0] == 'last':
        with open(file_path) as handle:
            for line in handle:
                if line.strip().startswith(ref.mol_tags[select][1]) or line.strip().endswith(ref.mol_tags[select][1]):
                    values = re.findall(ref.float_regex, line)
                    out = float(values[-1])
    elif ref.mol_tags[select][0] == 'first':
        with open(file_path) as handle:
            for line in handle:
                if line.strip().startswith(ref.mol_tags[select][1]) or line.strip().endswith(ref.mol_tags[select][1]):
                    values = re.findall(ref.float_regex, line)
                    out = float(values[0])
                    break
    elif ref.mol_tags[select][0] == 'simple':
        with open(file_path) as handle:
            occ_count = 0
            for line in handle:
                if line.strip().startswith(ref.mol_tags[select][1]) or line.strip().endswith(ref.mol_tags[select][1]):
                    occ_count += 1
                    if occ_count == ref.mol_tags[select][3]:
                        values = re.findall(ref.float_regex, line)
                        out = float(values[ref.mol_tags[select][2]-1])
    else:
        print(f'Select must be: {ref.mol_tags.keys()}')
    if conv and out:
        out = out*const
    return out

@arg_file_handler
def geometric(file_path, atoms, select):
    with open(file_path) as handle:
        #printout.append('\n###############  NEW INPUT ###############\n')
        #printout.append(f'Reading file: <{file_path}> {datetime.now().strftime("%b-%d-%Y %H:%M:%S")}\n')
        coordinates = list()
        for line in handle:
            if line.strip().startswith('Symbolic Z-matrix:'):
                next(handle)
                while True:
                    line = next(handle)
                    if not line.strip():
                        break
                    else:
                        values = line.strip().split()
                        values = [float(v) for v in values[1:]]
                        coordinates.append(values)
                break
    if select == 'Distance':
        return distance(coordinates[atoms[0]-1], coordinates[atoms[1]-1])
    elif select == 'Angle':
        return angle(coordinates[atoms[0]-1], coordinates[atoms[1]-1], coordinates[atoms[2]-1])
    elif select == 'Dihedral':
        return dihedral(coordinates[atoms[0]-1], coordinates[atoms[1]-1], coordinates[atoms[2]-1], coordinates[atoms[3]-1])
    else:
        print(f'Select must be: {ref.geo_tags}')

@arg_file_handler
def mulliken(file_path, atom_idx, select, print_out=False):
    # holds main lines for output (mainlly for debugg)
    printout = list()
    
    # open file for search:
    out = None
    with open(file_path) as handle:
        #printout.append('\n###############  NEW INPUT ###############\n')
        printout.append(f'Reading file: <{file_path}> {datetime.now().strftime("%b-%d-%Y %H:%M:%S")}\n')
        for line in handle:
            if line.strip().startswith(ref.Mulliken_tags[select][0]):
                printout.append(line)
                # Jumps the headline of output table
                next(handle)
                while True:
                    line = next(handle)
                    # Stops iteration on Mullinken table of results
                    if not line.strip()[0].isdigit():
                        break
                    # Matches the atom and get the selected value
                    if line.strip().split()[0] == str(atom_idx):
                        printout.append(line)
                        values = re.findall(ref.float_regex, line)
                        out = float(values[ref.Mulliken_tags[select][1]])
    if print_out:
        with open(f'{os.path.split(file_path)[0]}\\Mulliken.loglog', 'a') as file:
            for log in printout:
                print(log)
                file.write(log)
            file.write('\n\n')
    return out # Returns the last found output

@arg_file_handler
def pop_analysis(file_path, atom_idx, select, print_out=False):
    # holds main lines for output (mainlly for debugg)
    printout = list()
    
    # open file for search:
    out = None
    with open(file_path) as handle:
        #printout.append('\n###############  NEW INPUT ###############\n')
        printout.append(f'Reading file: <{file_path}> {datetime.now().strftime("%b-%d-%Y %H:%M:%S")}\n')
        occ_count = 0
        for line in handle:
            if line.strip().startswith('Summary of Natural Population Analysis:'):
                printout.append(line)
                occ_count += 1
                if occ_count == ref.NatA_tags[select][0]:
                    # Jumps the headline of output table
                    for _ in range(5):
                            next(handle)
                    while True:
                        line = next(handle)
                        # Stops iteration on Mullinken table of results
                        if line.strip()[0] == '=':
                            break
                        if line.strip().split()[1] == str(atom_idx):
                            values = re.findall(ref.float_regex, line)
                            out = float(values[ref.NatA_tags[select][1]])
                            break
                    break
    if print_out:
        with open(f'{os.path.split(file_path)[0]}\\pop_analysis.loglog', 'a') as file:
            for log in printout:
                print(log)
                file.write(log)
            file.write('\n\n')
    return out # Returns the last found output

@arg_file_handler
def nbo(file_path, atom_idx, select, orbital, order, print_out=False):
    # holds main lines for output (mainlly for debugg)
    printout = list()
    
    # open file for search:
    out = None
    with open(file_path) as handle:
        #printout.append('\n###############  NEW INPUT ###############\n')
        printout.append(f'Reading file: <{file_path}> {datetime.now().strftime("%b-%d-%Y %H:%M:%S")}\n')
        occ_count = 0
        for line in handle:
            if line.strip().startswith(ref.nbos_tags[select]):
                printout.append(line)
                while not line.strip().startswith('NATURAL BOND ORBITALS (Summary):'):
                    line = next(handle)
                while True:
                    line = next(handle)
                    # Break loop
                    if line.strip().startswith('Charge unit'):
                        for _ in range(2):
                            line = next(handle)
                        if not line.strip() or line.strip().startswith('$CHOOSE'):
                            break
                    
                    if ref.orbitals[orbital][0] == 'atom':
                        decode = line.strip().replace('(', ' ').replace(')', ' ').replace('-', ' ').split()[1:5]
                        if decode:
                            if decode[0] == orbital:
                                if int(decode[1]) == order and int(decode[3]) == atom_idx:
                                    values = re.findall(ref.float_regex, line)
                                    out = float(values[1])
                    
                    if ref.orbitals[orbital][0] == 'bond':
                        decode = line.strip().replace('(', ' ').replace(')', ' ').replace('-', ' ').split()[1:7]
                        if decode:
                            if decode[0] == orbital:
                                if int(decode[1]) == order and int(decode[3]) in atom_idx and int(decode[5]) in atom_idx:
                                    values = re.findall(ref.float_regex, line)
                                    out = float(values[1])
                break

    if print_out:
        with open(f'{os.path.split(file_path)[0]}\\pop_analysis.loglog', 'a') as file:
            for log in printout:
                print(log)
                file.write(log)
            file.write('\n\n')
    return out # Returns the last found output


    
